﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Threading;
using System.Reflection;
using System.IO;
using System.Xml.Linq;

namespace eWalletDataLiberator
{
	static class Program
	{
		private static bool sEWalletExited = false;
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			var eWalletApplicationType = typeof(eWallet.MainForm).Assembly.GetType("YwG5XPAUlPMWjWMbZ5.BZ2vrftl11kofIPf9C");

			Thread waitForEWallet = new Thread(WaitForEWallet);
			waitForEWallet.SetApartmentState(ApartmentState.STA);
			waitForEWallet.Start();

			//Execute eWallet (this is synchronous)
			eWalletApplicationType.GetMethod("6vq4ho0fs", BindingFlags.NonPublic | BindingFlags.Static).Invoke(null, new object[] { new string[0] });
			sEWalletExited = true;
		}

		private static void WaitForEWallet()
		{
			//Wait for main form to be available
			var formField = typeof(eWallet.MainForm).Assembly.GetType("YwG5XPAUlPMWjWMbZ5.BZ2vrftl11kofIPf9C").GetField("yGfTEugoj");
			eWallet.MainForm form = null;
			int timeout = 0;
			while ((form = (eWallet.MainForm)formField.GetValue(null)) == null)
			{
				Thread.Sleep(500);
				if (sEWalletExited)
				{
					MessageBox.Show("eWallet is already running. Please exit it before running " + Application.ProductName, Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
					return;
				}
				if (++timeout > 40) //If over 20s, timeout.
				{
					MessageBox.Show("Could not connect to eWallet. If it is running, please exit it before running " + Application.ProductName, Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
					return;
				}
			}

			//Main form is now available, wait for wallet to be available
			if (MessageBox.Show("Go to eWallet, open the wallet or template to extract the data from (including entering the password), then click OK", Application.ProductName, MessageBoxButtons.OKCancel) != DialogResult.OK)
			{
				//Exit.
				form.Invoke(new Action(() => form.Close()));
				return;
			}

			var wallet = (DBWalletDotNet.Wallet)form.GetType().GetField("rlUfB6iA4F", BindingFlags.NonPublic | BindingFlags.Instance).GetValue(form);

			var saveFileDialog = new SaveFileDialog()
									{
										Title = String.Format("Save extracted data from {0} ({1} cards)", Path.GetFileName(wallet.Path), wallet.Cards.AllCards.Count),
										Filter = "XML files (*.xml)|*.xml|All Files (*.*)|*.*",
										DefaultExt = "xml"
									};

			StreamWriter outputFile;
				
			while (true) //Until a valid file breaks out
			{
				if (saveFileDialog.ShowDialog() == DialogResult.Cancel)
				{
					//Exit.
					form.Invoke(new Action(() => form.Close()));
					return;
				}
				//Try to create the file
				try
				{
					outputFile = File.CreateText(saveFileDialog.FileName);
					//File seems valid, break out
					break;
				}
				catch (Exception ex)
				{
					if (MessageBox.Show("Could not create file: " + saveFileDialog.FileName + "\n\n" + ex.Message, Application.ProductName, MessageBoxButtons.RetryCancel) == DialogResult.Cancel)
					{
						//Exit.
						form.Invoke(new Action(() => form.Close()));
						return;
					}
				}
			}

			var xWallet = new XElement("Wallet");

			//Get categories
			var categoryLookup = new Dictionary<long, XElement>();
			foreach (long categoryId in wallet.Categories.GetChildCategoryIds(0))
			{
				xWallet.Add(CreateXCategory(wallet, categoryLookup, categoryId));
			}

			foreach (long cardId in wallet.Cards.AllCards)
			{
				//Construct a card for reading that data
				var card = new DBWalletDotNet.Card(wallet, cardId);

				XElement xCard;
				if (card.IsShortcut)
				{
					xCard = new XElement("Shortcut");

					xCard.Add(new XAttribute("id", cardId));
					xCard.Add(new XAttribute("name", card.Name));

					xCard.Add(new XAttribute("target", card.ShortcutSourceCardId));
				}
				else
				{
					//Write data out to XML file
					xCard = new XElement("Card");

					xCard.Add(new XAttribute("id", cardId));
					xCard.Add(new XAttribute("name", card.Name));

					xCard.Add(new XAttribute("kind", card.Kind));
					if (card.TemplateName != null)
					{
						xCard.Add(new XAttribute("templateName", card.TemplateName));
					}

					if (card.BackgroundColor.HasValue)
					{
						xCard.Add(new XAttribute("backgroundColor", System.Drawing.ColorTranslator.ToHtml(card.BackgroundColor.Value)));
					}
					if (card.TextColor.HasValue)
					{
						xCard.Add(new XAttribute("textColor", System.Drawing.ColorTranslator.ToHtml(card.TextColor.Value)));
					}

					xCard.Add(new XAttribute("showGradient", card.Gradient == DBWalletDotNet.ShowHide.Show));
					xCard.Add(new XAttribute("showIcon", card.Icon == DBWalletDotNet.ShowHide.Show));
					xCard.Add(new XAttribute("showBorder", card.Border == DBWalletDotNet.ShowHide.Show));
					xCard.Add(new XAttribute("showScrollBars", card.ScrollBars == DBWalletDotNet.ShowHide.Show));

					xCard.Add(new XAttribute("viewKind", card.ViewKind));

					xCard.Add(new XAttribute("cornerShape", card.CornerShape));
					if (card.FontSize.HasValue)
					{
						xCard.Add(new XAttribute("fontSize", card.FontSize.Value));
					}
					xCard.Add(new XAttribute("imagePosition", card.ImagePosition));


					xCard.Add(new XAttribute("iconKind", card.IconKind));
					xCard.Add(new XAttribute("standardIcon", card.StandardIcon));
					if (card.CustomIcon != null)
					{
						xCard.Add(new XAttribute("customIcon", card.CustomIcon));
					}

					xCard.Add(new XElement("Face", CreateXFields(card, card.AllFaceFields)));
					xCard.Add(new XElement("Detail", CreateXFields(card, card.AllDetailsFields)));

					xCard.Add(new XElement("Notes", card.Notes));

					
					AddAttachment(xCard, card, DBWalletDotNet.FileAttachmentSlot.Graphics, "Image");
					AddAttachment(xCard, card, DBWalletDotNet.FileAttachmentSlot.Generic, "Attachment");

				}
				var xCategory = categoryLookup[card.CategoryId];
				xCategory.Add(xCard);

			}

			xWallet.Save(outputFile);
			
			form.Invoke(new Action(() => form.Close()));
			MessageBox.Show("Data extraction complete, eWallet has been closed.", Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Information);
		}

		private static void AddAttachment(XElement xCard, DBWalletDotNet.Card card, DBWalletDotNet.FileAttachmentSlot slot, string name)
		{
			var kind = card.GetAttachedFileType(slot);
			if (kind != DBWalletDotNet.FileAttachmentKind.None)
			{
				var attachment = new XElement(name, new XAttribute("path", card.GetAttachedPath(slot)));
				if (kind == DBWalletDotNet.FileAttachmentKind.Embedded)
				{
					attachment.Add(System.Convert.ToBase64String(card.GetEmbeddedFileData(slot)));
				}
				xCard.Add(attachment);
			}
		}

		private static IEnumerable<XElement> CreateXFields(DBWalletDotNet.Card card, IEnumerable<int> fieldIDs)
		{
			foreach (var fieldID in fieldIDs)
			{
				var xField = new XElement("Field");
				xField.Add(new XAttribute("label", card.GetFieldLabel(fieldID)));
				xField.Add(new XAttribute("kind", card.GetFieldKind(fieldID)));
				xField.Add(card.GetFieldValue(fieldID));
				yield return xField;
			}
		}

		private static XElement CreateXCategory(DBWalletDotNet.Wallet wallet, Dictionary<long, XElement> categoryLookup, long categoryId)
		{
			var category = new DBWalletDotNet.Category(wallet, categoryId);
			var xCategory = new XElement("Category");
			xCategory.Add(new XAttribute("id", categoryId));
			xCategory.Add(new XAttribute("name", category.Name));
			xCategory.Add(new XAttribute("defaultCardKind", category.DefaultCardKind));
			xCategory.Add(new XAttribute("defaultCardTemplate", category.DefaultCardTemplate));
			xCategory.Add(new XAttribute("iconKind", category.IconKind));
			xCategory.Add(new XAttribute("standardIcon", category.StandardIcon));
			if (category.CustomIcon != null)
			{
				xCategory.Add(new XAttribute("customIcon", category.CustomIcon));
			}

			categoryLookup.Add(categoryId, xCategory);

			//Write out child categories
			foreach (long childId in wallet.Categories.GetChildCategoryIds(categoryId))
			{
				xCategory.Add(CreateXCategory(wallet, categoryLookup, childId));
			}

			return xCategory;
		}
	}
}
